package gov.va.vamf.service.shifttransition.watchlist;

import gov.va.vamf.service.shifttransition.application.representations.Link;
import gov.va.vamf.service.shifttransition.application.resources.Routes;
import gov.va.vamf.service.shifttransition.tasks.representations.PatientTasksStatus;
import org.junit.Test;

import javax.ws.rs.core.*;
import java.util.*;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

/**
 * Add a Description.  Should include class purpose (why not what) and assumptions.
 */
public class PatientTasksStatusTests {
    @Test
    public void generatedLinks() {
        UriInfo info = mock(UriInfo.class);
        when(info.getBaseUriBuilder()).thenReturn(UriBuilder.fromPath("http://localhost/rest/v1"));

        PatientTasksStatus patientTasksStatus = new PatientTasksStatus();
        patientTasksStatus.patientId = "123";
        patientTasksStatus.generateLinks(new Routes(info, "siteId", "userId"));

        List<Link> links = patientTasksStatus.links;

        assertEquals(3, links.size());
        assertEquals("get-patient-task-summaries", links.get(0).title);
        assertEquals("remove-patient-my-list", links.get(1).title);
        assertEquals("http://localhost/rest/v1/nsc-service/facility/siteId/patients/123/tasks", links.get(0).href);
        assertEquals("http://localhost/rest/v1/nsc-service/facility/siteId/my-patient-list/userId/patients/123", links.get(1).href);
        assertEquals("http://localhost/rest/v1/nsc-service/facility/siteId/patients/123/completedTasks", links.get(2).href);
    }
}
