package gov.va.vamf.service.shifttransition.watchlist;

import gov.va.vamf.service.shifttransition.application.representations.Link;
import gov.va.vamf.service.shifttransition.application.resources.Routes;
import org.junit.Test;

import javax.ws.rs.core.*;
import java.util.List;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class PatientListTests {
    @Test
    public void generatedLinks() {
        UriInfo info = mock(UriInfo.class);
        when(info.getBaseUriBuilder()).thenReturn(UriBuilder.fromPath("http://localhost/rest/v1"));

        PatientList patientList = new PatientList();
        patientList.generateLinks(new Routes(info, "siteId", "userId"));

        List<Link> links = patientList.links;

        assertEquals(4, links.size());
        assertEquals("my-list", links.get(0).title);
        assertEquals("add-patient-my-list", links.get(1).title);
        assertEquals("patients-tasks-status", links.get(2).title);
        assertEquals("patients-tasks", links.get(3).title);
        assertEquals("http://localhost/rest/v1/nsc-service/facility/siteId/my-patient-list/userId", links.get(0).href);
        assertEquals("http://localhost/rest/v1/nsc-service/facility/siteId/my-patient-list/userId", links.get(1).href);
        assertEquals("http://localhost/rest/v1/nsc-service/facility/siteId/my-patient-list/userId/patients/tasks/status", links.get(2).href);
        assertEquals("http://localhost/rest/v1/nsc-service/facility/siteId/my-patient-list/userId/patients/tasks", links.get(3).href);
    }
}
