package gov.va.vamf.service.shifttransition.watchlist;

import org.junit.*;

import javax.ws.rs.WebApplicationException;

import static org.junit.Assert.*;

/**
 * Add a Description.  Should include class purpose (why not what) and assumptions.
 */
public class MyPatientsTests {

    private MyPatients myPatients;

    @Before
    public void init() {
        myPatients = new MyPatients("123", "456");
    }

    @Test
    public void addPatient() {
        myPatients.add(createPerson("newId"));

        assertTrue(myPatients.asPatientList().patientIds().contains("newId"));
    }

    @Test
    public void removePatient() {
        myPatients.add(createPerson("1"));
        myPatients.add(createPerson("2"));
        myPatients.add(createPerson("3"));

        assertEquals(3, myPatients.asPatientList().patientIds().size());
        assertTrue(myPatients.asPatientList().patientIds().contains("2"));

        myPatients.remove("2");

        assertFalse(myPatients.asPatientList().patientIds().contains("2"));
    }

    @Test(expected = WebApplicationException.class)
    public void patientIdAlreadyInList() {
        myPatients.add(createPerson("1"));
        myPatients.add(createPerson("1"));
    }

    private Person createPerson(String uniqueId) {
        Person person = new Person();
        person.identity = new PersonIdentity("456", uniqueId);
        person.name = new Name("PII", "PII", "r");

        return person;
    }

    @Test(expected = WebApplicationException.class)
    public void patientCannotBeNull() {
        myPatients.add(null);
    }

    @Test(expected = WebApplicationException.class)
    public void patientCannotHaveDifferentAssignAuthority() {
        Person person = new Person();
        person.identity = new PersonIdentity("abc", "123");

        myPatients.add(person);
    }
}
