package gov.va.vamf.service.shifttransition.tasks.representations;

import gov.va.vamf.service.shifttransition.tasks.representations.UpdatedScheduledTask;
import org.junit.Test;

import javax.ws.rs.WebApplicationException;
import java.util.Date;

public class UpdatedScheduledTaskTests {
    @Test(expected = WebApplicationException.class)
    public void nullStartDate() {
        UpdatedScheduledTask scheduledTask = new UpdatedScheduledTask();
        scheduledTask.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void endDateAfterStartDate() {
        UpdatedScheduledTask scheduledTask = new UpdatedScheduledTask();

        scheduledTask.startDate = new Date();
        scheduledTask.endDate = new Date(scheduledTask.startDate.getTime() - 6000);

        scheduledTask.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void nullScheduleFrequency() {
        UpdatedScheduledTask scheduledTask = new UpdatedScheduledTask();

        scheduledTask.startDate = new Date();
        scheduledTask.scheduleType = "Custom";

        scheduledTask.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void invalidScheduleType() {
        UpdatedScheduledTask scheduledTask = new UpdatedScheduledTask();

        scheduledTask.startDate = new Date();
        scheduledTask.scheduleType = "PII";
        scheduledTask.scheduleFrequency = "I1;D1:H0;M0";

        scheduledTask.validateInput();

    }
}
