package gov.va.vamf.service.shifttransition.tasks.representations;

import gov.va.vamf.service.shifttransition.application.representations.Link;
import gov.va.vamf.service.shifttransition.application.resources.Routes;
import org.junit.Test;

import javax.ws.rs.core.*;
import java.util.List;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class ScheduledTasksTests {
    @Test
    public void generatedLinks() {
        UriInfo info = mock(UriInfo.class);
        when(info.getBaseUriBuilder()).thenReturn(UriBuilder.fromPath("http://localhost/rest/v1"));

        ScheduledTask scheduledTask = new ScheduledTask();
        scheduledTask.taskId = "6";
        scheduledTask.generateLinks(new Routes(info, "siteId", "patientId"));

        List<Link> links = scheduledTask.links;

        assertEquals(1, links.size());
        assertEquals("update-existing-task", links.get(0).title);
        assertEquals("http://localhost/rest/v1/nsc-service/facility/siteId/patients/patientId/tasks/6", links.get(0).href);
    }
}
