package gov.va.vamf.service.shifttransition.tasks.representations;

import gov.va.vamf.service.shifttransition.application.representations.Link;
import gov.va.vamf.service.shifttransition.application.resources.Routes;
import org.junit.Test;

import javax.ws.rs.core.*;
import java.util.List;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class PatientTaskSummaryTests {
    @Test
    public void generatedLinks() {
        UriInfo info = mock(UriInfo.class);
        when(info.getBaseUriBuilder()).thenReturn(UriBuilder.fromPath("http://localhost/rest/v1"));

        PatientTaskSummaries summaries = new PatientTaskSummaries();
        PatientTaskSummary summary = new PatientTaskSummary();
        summary.taskId = "5";

        summaries.tasks.add(summary);

        summaries.generateLinks(new Routes(info, "siteId", "patientId"));

        List<Link> links = summaries.links;

        assertEquals(3, links.size());
        assertEquals("get-patient-task-summaries", links.get(0).title);
        assertEquals("add-new-task", links.get(1).title);
        assertEquals("get-completed-tasks", links.get(2).title);
        assertEquals("http://localhost/rest/v1/nsc-service/facility/siteId/patients/patientId/tasks", links.get(0).href);
        assertEquals("http://localhost/rest/v1/nsc-service/facility/siteId/patients/patientId/tasks", links.get(1).href);
        assertEquals("http://localhost/rest/v1/nsc-service/facility/siteId/patients/patientId/completedTasks", links.get(2).href);

        links = summaries.tasks.get(0).links;

        assertEquals(2, links.size());
        assertEquals("get-patient-task", links.get(0).title);
        assertEquals("complete-patient-task", links.get(1).title);
        assertEquals("http://localhost/rest/v1/nsc-service/facility/siteId/patients/patientId/tasks/5", links.get(0).href);
        assertEquals("http://localhost/rest/v1/nsc-service/facility/siteId/patients/patientId/completedTasks/5", links.get(1).href);
    }
}
