package gov.va.vamf.service.shifttransition.tasks.representations;

import gov.va.vamf.service.shifttransition.tasks.representations.NewScheduledTask;
import org.junit.Test;

import javax.ws.rs.WebApplicationException;

public class NewScheduledTaskTests {
    @Test(expected = WebApplicationException.class)
    public void taskNameNull() {
        NewScheduledTask newScheduledTask = new NewScheduledTask();
        newScheduledTask.type = "Custom";
        newScheduledTask.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void taskNameBlank() {
        NewScheduledTask newScheduledTask = new NewScheduledTask();
        newScheduledTask.type = "Custom";
        newScheduledTask.name = "";
        newScheduledTask.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void taskTypeNull() {
        NewScheduledTask newScheduledTask = new NewScheduledTask();
        newScheduledTask.name = "Flip";
        newScheduledTask.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void taskTypeBlank() {
        NewScheduledTask newScheduledTask = new NewScheduledTask();
        newScheduledTask.type = "";
        newScheduledTask.name = "Turn";
        newScheduledTask.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void taskTypeNotCustomButExternalUrlNull() {
        NewScheduledTask newScheduledTask = new NewScheduledTask();
        newScheduledTask.type = "Clio";
        newScheduledTask.name = "Turn";
        newScheduledTask.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void taskTypeNotCustomButExternalUrlBlank() {
        NewScheduledTask newScheduledTask = new NewScheduledTask();
        newScheduledTask.type = "Clio";
        newScheduledTask.name = "Turn";
        newScheduledTask.externalTaskUrl = "";
        newScheduledTask.validateInput();
    }
}
