package gov.va.vamf.service.shifttransition.tasks.domain.time;

import org.junit.Test;

import javax.ws.rs.WebApplicationException;
import java.util.*;

import static org.junit.Assert.*;

/**
 * Add a Description.  Should include class purpose (why not what) and assumptions.
 */
public class TimeTests {

    public static final String AMERICA_CHICAGO_TIMEZONE = "America/Chicago";

    @Test
    public void sortTimes() {
        Time a = Time.create("2300");
        Time b = Time.create("1000");
        Time c = Time.create("1330");

        Time[] times = new Time[]{a, b, c};

        Arrays.sort(times);

        assertTrue(times[0].after(null));
        assertTrue(times[0].after(Time.createNullTime()));
        assertTrue(times[1].after(times[0]));
        assertTrue(times[2].after(times[1]));

        assertFalse(times[0].after(times[2]));
        assertFalse(times[1].after(times[2]));
        assertFalse(times[2].after(times[2]));
    }

    @Test
    public void setTimeOnDueDate() {
        Calendar calendar = getTodayAtOneThrityInCDT();

        //set time of 13:30 CDT
        Time time = Time.create(AMERICA_CHICAGO_TIMEZONE, calendar.getTime());

        //DueDate to change time to 13:30 CDT
        DueDate dueDate = createDueDateAtTenAMCDT(calendar);

        time.setTimeOn(dueDate);

        //verify time changed to 1330 CDT
        Calendar verifyDate = Calendar.getInstance(TimeZone.getTimeZone(AMERICA_CHICAGO_TIMEZONE));
        verifyDate.setTime(dueDate.get());

        assertEquals(13, verifyDate.get(Calendar.HOUR_OF_DAY));
        assertEquals(30, verifyDate.get(Calendar.MINUTE));
    }

    private DueDate createDueDateAtTenAMCDT(Calendar calendar) {
        calendar.set(Calendar.HOUR_OF_DAY, 10);
        calendar.set(Calendar.MINUTE, 0);

        return new DueDate(calendar.getTime(), AMERICA_CHICAGO_TIMEZONE);
    }

    private Calendar getTodayAtOneThrityInCDT() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(AMERICA_CHICAGO_TIMEZONE));
        calendar.setTime(new Date());
        calendar.set(Calendar.HOUR_OF_DAY, 13);
        calendar.set(Calendar.MINUTE, 30);
        return calendar;
    }

    @Test
    public void createTimeWithNullString() {
        Time time = Time.create(null);
        assertTrue(time.isNull());
    }

    @Test
    public void createTimeWithNullDate() {
        Time time = Time.create(AMERICA_CHICAGO_TIMEZONE, null);
        assertTrue(time.isNull());
    }

    @Test(expected = WebApplicationException.class)
    public void invalidHourTimeValue() {
        Time.create("2500");
    }

    @Test(expected = WebApplicationException.class)
    public void invalidMinuteTimeValue() {
        Time.create("2090");
    }

}