package gov.va.vamf.service.shifttransition.tasks.domain.time;

import org.junit.*;

import java.util.Date;

import static org.junit.Assert.*;

public class RangeTests {

    public static final int TEN_MINUTES_IN_MILLISECONDS = 10 * 60 * 1000;

    private Range range;
    private Date now;

    @Before
    public void init() {
        now = new Date();

        //10 minutes before and after now
        range = new Range(new Date(now.getTime() - TEN_MINUTES_IN_MILLISECONDS), new Date(now.getTime() + TEN_MINUTES_IN_MILLISECONDS));
    }

    @Test
    public void isRangeWithNullDate() {
        assertFalse(range.isInRange(null));
    }

    @Test
    public void inRange() {
        assertTrue(range.isInRange(new DueDate(now)));
    }

    @Test
    public void inRangeAtBoundaries() {
        assertTrue(range.isInRange(new DueDate(new Date(now.getTime() - TEN_MINUTES_IN_MILLISECONDS))));
        assertTrue(range.isInRange(new DueDate(new Date(now.getTime() + TEN_MINUTES_IN_MILLISECONDS))));
    }

}
