package gov.va.vamf.service.shifttransition.tasks.domain.time;

import org.junit.*;

import javax.ws.rs.WebApplicationException;
import java.util.*;

import static org.junit.Assert.*;

public class DueDateTests {

    private Date now;
    private DueDate dueDate;


    @Before
    public void init() {
        now = new Date();
        dueDate = new DueDate(now);
    }

    @Test(expected = WebApplicationException.class)
    public void notDateNotSupported() {
        new DueDate(null);
    }

    @Test
    public void addTimeToDueDate() {
        dueDate.addDays(1).addHours(2).addMinutes(-10);

        Calendar calendar = addMinutesToNow(-10);
        calendar.add(Calendar.DATE, 1);
        calendar.add(Calendar.HOUR_OF_DAY, 2);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        assertEquals(calendar.getTime(), dueDate.get());
    }

    @Test
    public void setHoursAndMinutes() {
        dueDate.setHours(23).setMinutes(30);

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 30);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        assertEquals(calendar.getTime(), dueDate.get());
    }

    @Test
    public void dateBefore() {
        Calendar calendar = addMinutesToNow(10);

        assertTrue(dueDate.before(new DueDate(calendar.getTime())));

        calendar.add(Calendar.HOUR_OF_DAY, -2);

        assertFalse(dueDate.before(new DueDate(calendar.getTime())));
    }

    @Test
    public void dateAfter() {
        Calendar calendar = addMinutesToNow(-10);

        assertTrue(dueDate.after(new DueDate(calendar.getTime())));

        calendar.add(Calendar.HOUR_OF_DAY, 2);

        assertFalse(dueDate.after(new DueDate(calendar.getTime())));
    }

    @Test
    public void dateBetween() {
        Calendar start = addMinutesToNow(-10);
        Calendar end = addMinutesToNow(10);

        assertTrue(dueDate.between(new DueDate(start.getTime()), new DueDate(end.getTime())));

        assertFalse(dueDate.between(new DueDate(now), new DueDate(end.getTime())));
        assertFalse(dueDate.between(new DueDate(start.getTime()), new DueDate(now)));
    }

    private Calendar addMinutesToNow(int minutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(Calendar.MINUTE, minutes);

        return calendar;
    }

    @Test
    public void dateEqual() {
        assertEquals(dueDate, dueDate);

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);

        assertEquals(dueDate, new DueDate(calendar.getTime()));
    }

    @Test
    public void createDateWithTimezone() {
        Date now = new Date();
        DueDate dueDate = new DueDate(now, "America/Chicago");

        assertNotEquals(now.getTime(), dueDate.get());
    }
}
