package gov.va.vamf.service.shifttransition.tasks.domain.time;

import static org.junit.Assert.*;
import gov.va.vamf.service.shifttransition.infrastructure.exception.WebApp400BadRequestException;

import org.junit.Test;

public class CustomTaskWeekTests {
	@Test(expected = WebApp400BadRequestException.class)
    public void invalidWeek() {
        CustomTaskWeek.fromValue("BOGUS");
    }
	
	@Test(expected = WebApp400BadRequestException.class)
    public void invalidWeekNull() {
        CustomTaskWeek.fromValue(null);
    }
	
	@Test(expected = WebApp400BadRequestException.class)
    public void invalidWeekEmpty() {
        CustomTaskWeek.fromValue("");
    }
	
	@Test
	public void fromValue() {
		CustomTaskWeek week = CustomTaskWeek.fromValue("Weekly");
		assertEquals(CustomTaskWeek.Weekly, week);
		week = CustomTaskWeek.fromValue("EveryOther");
		assertEquals(CustomTaskWeek.EveryOther, week);
		week = CustomTaskWeek.fromValue("EveryThird");
		assertEquals(CustomTaskWeek.EveryThird, week);
		week = CustomTaskWeek.fromValue("EveryFourth");
		assertEquals(CustomTaskWeek.EveryFourth, week);
	}
	
	@Test
	public void isValid() {
		boolean valid = CustomTaskWeek.isValid("Weekly");
		assertTrue(valid);
		valid = CustomTaskWeek.isValid("EveryOther");
		assertTrue(valid);
		valid = CustomTaskWeek.isValid("EveryThird");
		assertTrue(valid);
		valid = CustomTaskWeek.isValid("EveryFourth");
		assertTrue(valid);
	}
}
