package gov.va.vamf.service.shifttransition.tasks.domain.time;

import static org.junit.Assert.*;
import gov.va.vamf.service.shifttransition.infrastructure.exception.WebApp400BadRequestException;

import org.junit.Test;

public class CustomTaskDaysTests {
	@Test(expected = WebApp400BadRequestException.class)
    public void invalidDays() {
        CustomTaskDays.fromValue("BOGUS");
    }
	
	@Test(expected = WebApp400BadRequestException.class)
    public void invalidDaysNull() {
        CustomTaskDays.fromValue(null);
    }
	
	@Test(expected = WebApp400BadRequestException.class)
    public void invalidDaysEmpty() {
        CustomTaskDays.fromValue("");
    }
	
	@Test
	public void fromValue() {
		CustomTaskDays day = CustomTaskDays.fromValue("All");
		assertEquals(CustomTaskDays.All, day);
		day = CustomTaskDays.fromValue("Sun");
		assertEquals(CustomTaskDays.Sun, day);
		day = CustomTaskDays.fromValue("Mon");
		assertEquals(CustomTaskDays.Mon, day);
		day = CustomTaskDays.fromValue("Tue");
		assertEquals(CustomTaskDays.Tue, day);
		day = CustomTaskDays.fromValue("Wed");
		assertEquals(CustomTaskDays.Wed, day);
		day = CustomTaskDays.fromValue("Thu");
		assertEquals(CustomTaskDays.Thu, day);
		day = CustomTaskDays.fromValue("Fri");
		assertEquals(CustomTaskDays.Fri, day);
		day = CustomTaskDays.fromValue("Sat");
		assertEquals(CustomTaskDays.Sat, day);
	}
	
	@Test
	public void isValid() {
		boolean valid = CustomTaskDays.isValid("All");
		assertTrue(valid);
		valid = CustomTaskDays.isValid("Sun");
		assertTrue(valid);
		valid = CustomTaskDays.isValid("Mon");
		assertTrue(valid);
		valid = CustomTaskDays.isValid("Tue");
		assertTrue(valid);
		valid = CustomTaskDays.isValid("Wed");
		assertTrue(valid);
		valid = CustomTaskDays.isValid("Thu");
		assertTrue(valid);
		valid = CustomTaskDays.isValid("Fri");
		assertTrue(valid);
		valid = CustomTaskDays.isValid("Sat");
		assertTrue(valid);
	}
}
