package gov.va.vamf.service.shifttransition.tasks.domain.rules.parsers;

import static org.junit.Assert.assertEquals;
import gov.va.vamf.service.shifttransition.infrastructure.exception.WebApp500InternalServerErrorException;
import gov.va.vamf.service.shifttransition.tasks.domain.time.CustomTaskDays;
import gov.va.vamf.service.shifttransition.tasks.domain.time.CustomTaskWeek;

import org.junit.Test;

public class CustomParserTest extends CustomParser {
	@Test(expected = WebApp500InternalServerErrorException.class)
    public void invalidScheduleFrequencyEmpty() {
        this.parse("", true);
    }
	
	@Test(expected = WebApp500InternalServerErrorException.class)
    public void emptyDaysWeek() {
        this.parse("America/Chicago;1000;1430;1815;2300||", true);
    }
	
	@Test(expected = WebApp500InternalServerErrorException.class)
    public void emptyDays() {
        this.parse("America/Chicago;1000;1430;1815;2300||Weekly", true);
    }
	
	@Test(expected = WebApp500InternalServerErrorException.class)
    public void emptyWeek() {
        this.parse("America/Chicago;1000;1430;1815;2300|Sun;Tue;Thu|", true);
    }
	
	@Test(expected = WebApp500InternalServerErrorException.class)
    public void missingWeek() {
        this.parse("America/Chicago;1000;1430;1815;2300|Sun;Tue;Thu", true);
    }
	
	@Test(expected = WebApp500InternalServerErrorException.class)
    public void missingDaysWeek() {
        this.parse("America/Chicago;1000;1430;1815;2300", true);
    }
	
	@Test
	public void fromValue() {
		this.parse("America/Chicago;1000;1430;1815;2300|Sun;Tue;Thu|Weekly", true);
		assertEquals(3, this.getDays().length);
		assertEquals(CustomTaskDays.Sun, this.getDays()[0]);
		assertEquals(CustomTaskDays.Tue, this.getDays()[1]);
		assertEquals(CustomTaskDays.Thu, this.getDays()[2]);
		assertEquals(CustomTaskWeek.Weekly, this.getWeek());
	}
}
