package gov.va.vamf.service.shifttransition.tasks.domain;

import gov.va.vamf.service.shifttransition.tasks.domain.time.*;
import gov.va.vamf.service.shifttransition.tasks.representations.*;
import org.junit.*;

import javax.ws.rs.WebApplicationException;
import java.util.*;

import static org.junit.Assert.*;

public class PatientTasksTests {
    public static final String CREATED_BY = "luke skywalker";
    private PatientTasks patientTasks;
    private NewScheduledTask newTask;

    @Before
    public void init() {
        patientTasks = new PatientTasks("patientId", "siteId");

        newTask = new NewScheduledTask();
        newTask.name = "NewTask";
        newTask.type = "Custom";
        newTask.startDate = new DueDate(new Date()).get(); //date/time without seconds or milliseconds
    }

    @Test
    public void getMostUrgentTasksWithZeroTask() {
        PatientTasksStatus patientTasksStatus = patientTasks.getMostUrgentTask(createRangeWithOffsets(0, 0));

        assertEquals("patientId", patientTasksStatus.patientId);
        assertEquals(TaskStatus.NA.toString(), patientTasksStatus.status);
        assertNull(patientTasksStatus.nextDueDate);
    }

    @Test
    public void getMostUrgentTasksWithOneTask() {
        patientTasks.addNewTask(newTask, CREATED_BY);

        PatientTasksStatus patientTasksStatus = patientTasks.getMostUrgentTask(createRangeWithOffsets(-600000, 600000));

        assertEquals("patientId", patientTasksStatus.patientId);
        assertEquals(newTask.startDate, patientTasksStatus.nextDueDate);
    }

    @Test
    public void getMostUrgentTasksWithOneTaskOutOfRange() {
        patientTasks.addNewTask(newTask, CREATED_BY);

        PatientTasksStatus patientTasksStatus = patientTasks.getMostUrgentTask(createRangeWithOffsets(-120000, -60000));

        assertEquals("patientId", patientTasksStatus.patientId);
        assertEquals(TaskStatus.NA.toString(), patientTasksStatus.status);
        assertNull(patientTasksStatus.nextDueDate);
    }

    @Test(expected = WebApplicationException.class)
    public void taskNotFound() {
        patientTasks.addNewTask(newTask, CREATED_BY);
        patientTasks.setNextDueDate("6");
    }

    @Test
    public void getAllTaskInRange() {
        patientTasks.addNewTask(newTask, CREATED_BY);
        patientTasks.addNewTask(newTask, CREATED_BY);
        patientTasks.addNewTask(newTask, CREATED_BY);

        List<PatientTaskSummary> summaries = patientTasks.getAllTasks(createRangeWithOffsets(-60000, 60000));

        assertEquals(3, summaries.size());
    }

    private Range createRangeWithOffsets(int startDateOffset, int endDateOffset) {
        return new Range(new Date(newTask.startDate.getTime() + startDateOffset), new Date(newTask.startDate.getTime() + endDateOffset));
    }
}
