package gov.va.vamf.service.shifttransition.tasks;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import gov.va.vamf.service.shifttransition.completedtasks.CompletedTask;
import gov.va.vamf.service.shifttransition.tasks.domain.PatientTasks;
import gov.va.vamf.service.shifttransition.tasks.domain.TaskStatus;
import gov.va.vamf.service.shifttransition.tasks.domain.time.Range;
import gov.va.vamf.service.shifttransition.tasks.representations.PatientTaskSummary;
import gov.va.vamf.service.shifttransition.tasks.representations.PatientTasksStatus;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

import com.google.common.collect.Lists;

public class TaskTransformServiceTests {

    private TaskTransformService service;

    @Before
    public void init() {
        service = new TaskTransformService();
    }

    @Test
    public void createPatientSummaryForCompletedTask() {
        CompletedTask completedTask = new CompletedTask();
        completedTask.taskName = "secure tesseract";
        completedTask.taskId = "05012013";
        completedTask.completedBy = "Thor";
        completedTask.siteId = "the collector";
        completedTask.dateCompleted = new Date();
        completedTask.patientId = "4567";
        completedTask.status = "Dismissed";

        List<CompletedTask> completedTaskList = Lists.newArrayList();
        completedTaskList.add(completedTask);

        List<PatientTaskSummary> summaries = service.createFromCompletedTasks(completedTaskList);

        PatientTaskSummary summary = summaries.get(0);

        assertEquals(completedTask.dateCompleted, summary.nextDueDate);
        assertEquals(completedTask.taskId, completedTask.taskId);
        assertEquals(completedTask.taskName, summary.taskName);
        assertEquals(completedTask.patientId, summary.patientId);
        assertEquals(completedTask.status, summary.status);
    }

    @Test
    public void getMostUrgentTask() {
        List<PatientTasks> patientTasksList = getPatientTasksWithZeroTasks();
        Range range = getRange();

        List<PatientTasksStatus> statuses = service.getMostUrgentTaskStatus(patientTasksList, range, new ArrayList<String>());

        PatientTasksStatus status = statuses.get(0);

        assertEquals("1010", status.patientId);
        assertEquals(TaskStatus.NA.toString(), status.status);
        assertNull(status.nextDueDate);
    }

    @Test
    public void getMostUrgentTaskForPatientsWithoutTasks() {
        List<String> patients =Lists.newArrayList("1234", "4567");
        Range range = getRange();

        List<PatientTasksStatus> statuses = service.getMostUrgentTaskStatus(new ArrayList<PatientTasks>(), range, patients);

        PatientTasksStatus status = statuses.get(0);

        assertEquals("1234", status.patientId);
        assertEquals(TaskStatus.NA.toString(), status.status);
        assertNull(status.nextDueDate);

        status = statuses.get(1);

        assertEquals("4567", status.patientId);
        assertEquals(TaskStatus.NA.toString(), status.status);
        assertNull(status.nextDueDate);
    }

    @Test
    public void getPatientTaskSummariesWithoutNAStatusTask() {
        List<PatientTasks> patientTasksList = getPatientTasksWithZeroTasks();
        Range range = getRange();

        List<PatientTaskSummary> summaries = service.getTasksSummariesWithoutNAStatusTask(patientTasksList, range);

        assertEquals(0, summaries.size());
    }

    private Range getRange() {
        return new Range(new Date(), new Date());
    }

    private List<PatientTasks> getPatientTasksWithZeroTasks() {
        PatientTasks patientTasks = new PatientTasks("1010", "51");

        List<PatientTasks> patientTasksList = Lists.newArrayList();
        patientTasksList.add(patientTasks);
        return patientTasksList;
    }
}
