package gov.va.vamf.service.shifttransition.dischargeprocess;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;

public class SiteCacheHandlerTests {
    private DischargeProcessBus bus;
    private SiteCacheHandler handler;

    @Before
    public void init() {
        bus = mock(DischargeProcessBus.class);
        handler = new SiteCacheHandler(bus);
    }

    @Test
    public void addingSiteTriggersMessage() {
        handler.addSiteHandler(new AddSiteEvent("123", "abc"));

        ArgumentCaptor<ProcessSiteEvent> argumentCaptor = ArgumentCaptor.forClass(ProcessSiteEvent.class);
        verify(bus, times(1)).post(argumentCaptor.capture());

        assertEquals("123", argumentCaptor.getValue().siteId());
        assertEquals("abc", argumentCaptor.getValue().token());
    }

    @Test
    public void addingExistingSiteDoesNotTriggerMessage() {
        handler.addSiteHandler(new AddSiteEvent("123", "dbc"));
        handler.addSiteHandler(new AddSiteEvent("123", "abc"));

        ArgumentCaptor<ProcessSiteEvent> argumentCaptor = ArgumentCaptor.forClass(ProcessSiteEvent.class);
        verify(bus, times(1)).post(argumentCaptor.capture());

        assertEquals("123", argumentCaptor.getValue().siteId());
        assertEquals("dbc", argumentCaptor.getValue().token());
    }

    @Test
    public void afterSiteRemovedMessageTriggered() {
        handler.addSiteHandler(new AddSiteEvent("123", "dbc"));
        handler.removeSiteHandler(new RemoveSiteEvent("123"));
        handler.addSiteHandler(new AddSiteEvent("123", "abc"));

        ArgumentCaptor<ProcessSiteEvent> argumentCaptor = ArgumentCaptor.forClass(ProcessSiteEvent.class);
        verify(bus, times(2)).post(argumentCaptor.capture());

        assertEquals("123", argumentCaptor.getValue().siteId());
        assertEquals("abc", argumentCaptor.getValue().token());
    }
}

