package gov.va.vamf.service.shifttransition.dischargeprocess;

import com.google.common.collect.*;
import gov.va.vamf.service.shifttransition.completedtasks.CompletedTasksRepository;
import gov.va.vamf.service.shifttransition.tasks.PatientTasksRepository;
import gov.va.vamf.service.shifttransition.tasks.domain.PatientTasks;
import gov.va.vamf.service.shifttransition.application.repositories.*;
import gov.va.vamf.service.shifttransition.infrastructure.patientsearch.InpatientResource;
import gov.va.vamf.service.shifttransition.watchlist.MyPatientsRepository;
import org.junit.Test;
import org.mockito.ArgumentCaptor;

import java.util.*;

import static org.junit.Assert.assertEquals;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.*;

public class PatientDischargeHandlerTests {
    @Test
    public void removeDischargePatient() throws Exception {
        PatientTasks patientTasks = mock(PatientTasks.class);

        PatientTasksRepository patientTasksRepository = mock(PatientTasksRepository.class);
        when(patientTasksRepository.getAllActivePatientTasksForSite("52")).thenReturn(getAggregateResults());
        when(patientTasksRepository.get("52", "1970")).thenReturn(patientTasks);

        List<AggregateResult> completedResults = getAggregateResults();
        completedResults.get(0).patientIds.remove("1970");

        CompletedTasksRepository completedTasksRepository = mock(CompletedTasksRepository.class);
        when(completedTasksRepository.getPatientsWithCompletedTaskInLast26HoursForSite("52")).thenReturn(completedResults);

        MyPatientsRepository myPatientsRepository = mock(MyPatientsRepository.class);

        RepositoryFactory factory = mock(RepositoryFactory.class);
        when(factory.getCompletedTasksRepository()).thenReturn(completedTasksRepository);
        when(factory.getPatientTasksRepository()).thenReturn(patientTasksRepository);
        when(factory.getMyPatientsRepository()).thenReturn(myPatientsRepository);

        InpatientResource inpatientResource = mock(InpatientResource.class);
        when(inpatientResource.patientStillAtFacility("52", "1970", "accessGranted")).thenReturn(false);

        PatientDischargeHandler handler = new PatientDischargeHandler(factory, inpatientResource, mock(DischargeProcessBus.class));
        handler.processSiteDischargesHandler(new ProcessSiteEvent("52", "abc"));

        verify(patientTasks).deactivate();
        verify(patientTasksRepository).save(any(PatientTasks.class));
        verify(myPatientsRepository).removePatientFromAllWatchList("52", "1970");
    }

    private List<AggregateResult> getAggregateResults() {
        Set<String> patientIds = Sets.newHashSet();
        patientIds.add("1970");
        patientIds.add("1972");

        AggregateResult aggregateResult = new AggregateResult();
        aggregateResult._id = "52";
        aggregateResult.patientIds = patientIds;
        List<AggregateResult> aggregateResults = Lists.newArrayList();
        aggregateResults.add(aggregateResult);

        return aggregateResults;
    }

    @Test
    public void removeMessageTriggeredOnError() {
        PatientTasksRepository patientTasksRepository = mock(PatientTasksRepository.class);
        when(patientTasksRepository.getAllActivePatientTasksForSite("52")).thenThrow(new RuntimeException("Nooooooo!"));

        RepositoryFactory factory = mock(RepositoryFactory.class);
        when(factory.getPatientTasksRepository()).thenReturn(patientTasksRepository);

        DischargeProcessBus bus = mock(DischargeProcessBus.class);

        PatientDischargeHandler handler = new PatientDischargeHandler(factory, mock(InpatientResource.class), bus);
        handler.processSiteDischargesHandler(new ProcessSiteEvent("52", "abc"));

        ArgumentCaptor<RemoveSiteEvent> argumentCaptor = ArgumentCaptor.forClass(RemoveSiteEvent.class);
        verify(bus, times(1)).post(argumentCaptor.capture());

        assertEquals("52", argumentCaptor.getValue().siteId());

    }

}
