package gov.va.vamf.service.shifttransition.dischargeprocess;

import com.google.common.eventbus.*;
import gov.va.vamf.service.shifttransition.dischargeprocess.DischargeProcessBus;
import org.junit.Test;

import java.util.concurrent.atomic.AtomicLong;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

public class DischargeProcessBusTests {
    private DischargeProcessBus bus;
    private AtomicLong timeInNanoSeconds;
    private int processCalledCount;

    @Test
    public void verifyBusWiring() throws InterruptedException {
        timeInNanoSeconds = new AtomicLong(0);
        processCalledCount = 0;

        bus = new DischargeProcessBus();
        bus.addEventHandler(this);

        //published async
        new Thread() {
            public void run(){
                bus.post(new CacheEvent("1"));
            }
        }.start();
        new Thread() {
            public void run(){
                bus.post(new CacheEvent("1"));
            }
        }.start();
        new Thread() {
            public void run(){
                bus.post(new CacheEvent("2"));
            }
        }.start();
        new Thread() {
            public void run(){
                bus.post(new CacheEvent("1"));
            }
        }.start();
        new Thread() {
            public void run(){
                bus.post(new CacheEvent("2"));
            }
        }.start();

        //pause for slow processing
        for (int i = 0; i < 5; i++) {
            Thread.sleep(100);

            if (processCalledCount == 3)
                break;
        }

        assertEquals(3, processCalledCount);
    }

    @Subscribe
    public void cache(CacheEvent event) throws InterruptedException {
        Long time = System.nanoTime();

        //verify events not called at the same time
        assertTrue(timeInNanoSeconds.getAndSet(time) < time);
        timeInNanoSeconds.getAndSet(System.nanoTime());

        if (event.siteId.equals("1")) {
           Thread.sleep(10);
           bus.post(new ProcessEvent(event.siteId));
        }
    }

    @Subscribe
    public void process(ProcessEvent event) {
        processCalledCount++;
        assertEquals("1", event.siteId);
    }

    public static class CacheEvent {
        public CacheEvent(String siteId) {
            this.siteId = siteId;
        }
        public String siteId;
    }

    public static class ProcessEvent {
        public ProcessEvent(String siteId) {
            this.siteId = siteId;
        }
        public String siteId;
    }

}
