package gov.va.vamf.service.shifttransition.completedtasks;

import gov.va.vamf.service.shifttransition.completedtasks.NewCompletedTask;
import org.junit.Test;

import javax.ws.rs.WebApplicationException;

public class NewCompletedTaskTest {
    @Test(expected = WebApplicationException.class)
    public void taskNameNull() {
        NewCompletedTask completedTask = new NewCompletedTask();
        completedTask.status = "Dismissed";
        completedTask.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void taskNameBlank() {
        NewCompletedTask completedTask = new NewCompletedTask();
        completedTask.status = "Completed";
        completedTask.taskName = "";
        completedTask.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void statusNull() {
        NewCompletedTask completedTask = new NewCompletedTask();
        completedTask.taskName = "Turn";
        completedTask.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void statusBlank() {
        NewCompletedTask completedTask = new NewCompletedTask();
        completedTask.taskName = "Flip";
        completedTask.status = "";
        completedTask.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void statusNotValidCompletedStatus() {
        NewCompletedTask completedTask = new NewCompletedTask();
        completedTask.taskName = "Flip";
        completedTask.status = "Pending";
        completedTask.validateInput();
    }
}
