package gov.va.vamf.service.shifttransition.completedtasks;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import gov.va.vamf.service.shifttransition.application.repositories.RepositoryFactory;

import java.util.Date;

import org.junit.Test;

public class CompletedTasksServiceTests {
    @Test
    public void createCompletedTaskFromNewCompletedTask() {
        NewCompletedTask newCompletedTask = new NewCompletedTask();
        newCompletedTask.taskName = "hide ufo";
        newCompletedTask.status = "Completed";
        newCompletedTask.comment = "hope no one saw it.";
        newCompletedTask.dateCompleted = new Date();

        CompletedTasksService service = new CompletedTasksService(new RepositoryFactory());
        CompletedTask completedTask = service.create("xray", "area 51", "1010", "PII", newCompletedTask);

        assertEquals("hide ufo", completedTask.taskName);
        assertEquals("Completed", completedTask.status);
        assertEquals("hope no one saw it.", completedTask.comment);
        assertEquals("xray", completedTask.patientId);
        assertEquals("area 51", completedTask.siteId);
        assertEquals("1010", completedTask.taskId);
        assertEquals("PII", completedTask.completedBy);
        assertNotNull(completedTask.dateCompleted);
    }
    
    @Test
    public void createCompletedTaskFromNewCompletedTaskWithOutOptionalParameters() {
        NewCompletedTask newCompletedTask = new NewCompletedTask();
        newCompletedTask.taskName = "hide ufo";
        newCompletedTask.status = "Completed";
        newCompletedTask.comment = "hope no one saw it.";

        CompletedTasksService service = new CompletedTasksService(new RepositoryFactory());
        CompletedTask completedTask = service.create("xray", "area 51", "1010", "PII", newCompletedTask);

        assertEquals("hide ufo", completedTask.taskName);
        assertEquals("Completed", completedTask.status);
        assertEquals("hope no one saw it.", completedTask.comment);
        assertEquals("xray", completedTask.patientId);
        assertEquals("area 51", completedTask.siteId);
        assertEquals("1010", completedTask.taskId);
        assertEquals("PII", completedTask.completedBy);
        assertNotNull(completedTask.dateCompleted);
    }
}
