package gov.va.vamf.service.shifttransition.watchlist;

import gov.va.vamf.service.shifttransition.application.representations.Namespace;
import gov.va.vamf.service.shifttransition.infrastructure.exception.WebApp400BadRequestException;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.google.common.base.Strings;

/**
 * Unique identifier for a person in Vista.  This could be either a nurse or a patient.
 */
@XmlRootElement(name = "person_identity", namespace = Namespace.ns)
public class PersonIdentity {
    /**
     * Should be a Vista assigningAuthority.  Ex: dfn-777.
     */
    @XmlElement()
    public String assigningAuthority;

    /**
     * Unique person id in one Vista system.
     */
    @XmlElement()
    public String uniqueId;

    public PersonIdentity() {}

    public PersonIdentity(String assigningAuthority, String uniqueId) {
        this.assigningAuthority = assigningAuthority;
        this.uniqueId = uniqueId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PersonIdentity that = (PersonIdentity) o;

        return assigningAuthority.equals(that.assigningAuthority) && uniqueId.equals(that.uniqueId);
    }

    @Override
    public int hashCode() {
        return 31 * assigningAuthority.hashCode() + uniqueId.hashCode();
    }

    public void validateIpout() {
        if (Strings.isNullOrEmpty(assigningAuthority) || Strings.isNullOrEmpty(uniqueId))
        	throw new WebApp400BadRequestException("Invalid person identity.  Valid assigning authority and unique id required.");
    }
}
