package gov.va.vamf.service.shifttransition.watchlist;

import gov.va.vamf.service.shifttransition.application.representations.Namespace;
import gov.va.vamf.service.shifttransition.infrastructure.exception.WebApp400BadRequestException;

import java.util.Date;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Represents a person.
 */
@XmlRootElement(name = "person", namespace = Namespace.ns)
public class Person {
    /**
     * Unique person identity.  Persons are equal if their person identities are equal.
     */
    @XmlElement()
    public PersonIdentity identity;

    /**
     * Name of person.  Can be null.
     */
    @XmlElement()
    public Name name;

    /**
     * Person's date of birth.  Can be null.
     */
    @XmlElement()
    public Date dob;

    /**
     * Used to store person's gender but not checked.  Can be null.
     */
    @XmlElement()
    public String gender;

    @Override
    public boolean equals(Object o) {
        return this == o || !(o == null || getClass() != o.getClass()) && identity.equals(((Person) o).identity);
    }

    @Override
    public int hashCode() {
        return identity.hashCode();
    }

    public void validateInput() {
        if (identity == null)
        	throw new WebApp400BadRequestException("Invalid person.  Person identity is required.");

        identity.validateIpout();
    }
}
