package gov.va.vamf.service.shifttransition.watchlist;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import gov.va.vamf.service.shifttransition.application.representations.*;
import gov.va.vamf.service.shifttransition.application.resources.Routes;

import javax.xml.bind.annotation.*;
import java.util.*;

/**
 * List of patient ids a nurse is watching.
 */
@XmlRootElement(name = "my_patients", namespace = Namespace.ns)
public class PatientList {
    /**
     * Unique identity for a nurse.
     */
     @XmlElement()
     public PersonIdentity nurse;

    /**
     * Zero or more patients from the same facility as the nurse.
     */
    @XmlElement()
    public List<Person> patients = Lists.newArrayList();

    /**
     * Returns related resources.
     * Titles ares: add-patient-my-list, patients-tasks, patients-tasks-status.
     */
    @XmlElement(name = "link", required = true)
    public List<Link> links = Lists.newArrayList();

    public void generateLinks(Routes routes) {
        Link selfLink = new Link("my-list", routes.getMyList());
        selfLink.rel = Link.self;

        links.add(selfLink);
        links.add(new Link("add-patient-my-list", routes.getAddPatientToMyList()));
        links.add(new Link("patients-tasks-status", routes.getMyPatientsTasksStatus()));
        links.add(new Link("patients-tasks", routes.getMyPatientsTaskSummaries()));
    }

    public List<String> patientIds() {
        List<String> patientIds = Lists.transform(patients, new Function<Person, String>() {

            public String apply(Person input) {
                return input.identity.uniqueId;
            }
        });

        return patientIds;
    }
}
