package gov.va.vamf.service.shifttransition.watchlist;

import gov.va.vamf.service.shifttransition.infrastructure.exception.WebApp500InternalServerErrorException;
import gov.va.vamf.service.shifttransition.infrastructure.mongo.MongoWrapper;

import org.jongo.MongoCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Interface for nurse's patient list mongodb collection.
 */
public class MyPatientsRepository {
    public static final String COLLECTION_NAME = "patient_lists";

    private static Logger logger = LoggerFactory.getLogger(MyPatientsRepository.class);

    MongoWrapper mongo = new MongoWrapper();

    public MyPatients get(String staffId, String siteId) {
        logger.debug("Getting nurses patient watch list for:  UserId {}, SiteId {}.", staffId, siteId);

        MyPatients patients;

        try {
            MongoCollection collection = mongo.getCollection(COLLECTION_NAME);

            patients = mongo.findOne(collection, "{staffId: '" + staffId + "', siteId: '" + siteId + "'}", MyPatients.class);
        } catch (Exception e) {
            logger.error("Unable to find nurse's watch list.", e);
            throw new WebApp500InternalServerErrorException("Unable to retrieve your patient list.  Please try again later.");
        }

        if (patients == null)
            patients = new MyPatients(staffId, siteId);

        return patients;
    }

    public void save(MyPatients patients) {
        logger.debug("Saving nurse patient watch list: ");

        try {
            MongoCollection collection = mongo.getCollection(COLLECTION_NAME);

            collection.save(patients);
        } catch (Exception e) {
            logger.error("Unable to save nurse's watch list.", e);
            throw new WebApp500InternalServerErrorException("Unable to save changes to your patient list.  Please try again later.");
        }
    }

    public void removePatientFromAllWatchList(String siteId, String patientId) {
        mongo.getCollection(COLLECTION_NAME).update("{siteId: '" + siteId + "'}").multi()
                .with("{$pull: {patients: {'identity.uniqueId': '" + patientId + "'}}}");
    }
}
