package gov.va.vamf.service.shifttransition.watchlist;

import gov.va.vamf.service.shifttransition.infrastructure.exception.WebApp400BadRequestException;

import java.util.List;

import org.jongo.marshall.jackson.oid.ObjectId;

import com.google.common.collect.Lists;

/**
 * Entity that represents a single nurse's patient watch list.
 */
public class MyPatients {
    @ObjectId
    private String _id;

    private String staffId;
    private String siteId;
    private List<Person> patients = Lists.newArrayList();

    public MyPatients() {}

    public MyPatients(String staffId, String siteId) {
        this.staffId = staffId;
        this.siteId = siteId;
    }

    public void add(Person patient) {
        if (patient == null)
        	throw new WebApp400BadRequestException("Cannot add an invalid patient to nurse's watch list.");

        if (!patient.identity.assigningAuthority.equalsIgnoreCase(siteId))
        	throw new WebApp400BadRequestException("Cannot add patient.  Patient must be at same facility as nurse.");

        if (patients.contains(patient))
        	throw new WebApp400BadRequestException("You have selected a patient that you are already tracking.");

        patients.add(patient);
    }

    public boolean remove(String patientId) {
        Person matchPerson = new Person();
        matchPerson.identity = new PersonIdentity(siteId, patientId);

        return patients.remove(matchPerson);
    }

    public PatientList asPatientList() {
        PatientList list = new PatientList();

        list.nurse = new PersonIdentity(siteId, staffId);
        list.patients.addAll(patients);

        return list;
    }
}
