package gov.va.vamf.service.shifttransition.userpreferences;

import java.util.Date;

import gov.va.vamf.service.shifttransition.application.representations.Namespace;
import org.jongo.marshall.jackson.oid.Id;
import org.jongo.marshall.jackson.oid.ObjectId;

import javax.xml.bind.annotation.*;

@XmlRootElement(name = "user_preferences", namespace = Namespace.ns)
public class MyPreferences {
	@Id
    @ObjectId
    public String _id;

	
	/**
     * Nurse's vista id for a specific facility.
     */
    public String staffId;

    /**
     * Facility that matches the nurse's vista id i.e. facility nurse is working at.
     */
    public String siteId;

    /**
     * User Preference of Start Date.
     */
    @XmlElement()
    public Date startDate;
    
    /**
     * User Preference of End Date
     */
    @XmlElement()
    public Date endDate;
	

    
    public MyPreferences() {
		
	}
	public MyPreferences(String staffId, String siteId) {
		this.staffId = staffId;
		this.siteId = siteId;
	}
}
