package gov.va.vamf.service.shifttransition.tasks.representations;

import gov.va.vamf.service.shifttransition.application.representations.*;
import gov.va.vamf.service.shifttransition.application.resources.Routes;

import javax.xml.bind.annotation.*;
import java.util.*;

/**
 * Latest description of a task. See representations below for details of possible values.
 *
 * @see gov.va.vamf.service.shifttransition.completedtasks.NewCompletedTask
 * @see UpdatedScheduledTask
 */
@XmlRootElement(name = "scheduled-task", namespace = Namespace.ns)
public class ScheduledTask {
    /**
     * Unique id for task.
     */
    @XmlElement()
    public String taskId;

    /**
     * Name of task.
     */
    @XmlElement()
    public String name;

    /**
     * Type of task.
     */
    @XmlElement()
    public String type;

    /**
     * Url to get data used to display and complete the task.
     */
    @XmlElement()
    public String externalTaskUrl;

    /**
     * Task comment.
     */
    @XmlElement()
    public String comment;

    /**
     * Name of nurse that create the task for the patient.
     */
    @XmlElement()
    public String createdBy;

    /**
     * Name of nurse that the latest changes to the task.
     */
    @XmlElement()
    public String lastModifiedBy;

    /**
     * UTC timestamp of the last time the task was modified which may be set to the time of creation.
     * Clients should format to local time for display.
     */
    @XmlElement()
    public Date lastModifiedDate;

    /**
     * UTC timestamp for the task start date. Clients should format to local time for display.
     */
    @XmlElement()
    public Date startDate;

    /**
     * UTC timestamp for the task end date. Clients should format to local time for display.
     */
    @XmlElement()
    public Date endDate;

    /**
     * Schedule type if task is reoccurring.
     */
    @XmlElement()
    public String scheduleType;

    /**
     * Schedule frequency pattern if the task is reoccurring.
     */
    @XmlElement()
    public String scheduleFrequency;

    /**
     * Returns related resources.
     * Titles ares: update-existing-task.
     */
    @XmlElement(name = "link")
    public List<Link> links = new ArrayList<Link>();

    public void generateLinks(Routes routes) {
        links.add(new Link("update-existing-task", routes.getUpdatePatientTask(taskId)));
    }
}
