package gov.va.vamf.service.shifttransition.tasks.representations;

import gov.va.vamf.service.shifttransition.application.representations.*;
import gov.va.vamf.service.shifttransition.application.resources.Routes;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 *  Holds the most urgent task status and matching due date from all tasks for a single patient.
 */
@XmlRootElement(name = "patient_tasks_status", namespace = Namespace.ns)
public class PatientTasksStatus {
    /**
     * Patient id from they same facility as the nurse.
     */
    @XmlElement()
    public String patientId;

    /**
     * Current most urgent status.  It is possible that the status is NA if there are no tasks due within
     * query date range or there are no tasks with any other more urgent status.
     */
    @XmlElement()
    public String status;

    /**
     * Due date of task with above status.  If status is NA this will be null.  Date is a UTC timestamp.  Clients must
     * format in the current timezone.
     */
    @XmlElement()
    public Date nextDueDate;

    /**
     * Returns related resources.
     * Titles ares: get-patient-task-summaries, remove-patient-my-list.
     */
    @XmlElement(name = "link", required = true)
    public List<Link> links = new ArrayList<Link>();

    public void generateLinks(Routes routes) {
        links.add(new Link("get-patient-task-summaries", routes.getPatientTaskSummaries(patientId)));
        links.add(new Link("remove-patient-my-list", routes.getRemovePatientFromMyList(patientId)));
        links.add(new Link("get-completed-tasks", routes.getPatientCompletedTasks(patientId)));
    }
}
