package gov.va.vamf.service.shifttransition.tasks.representations;

import gov.va.vamf.service.shifttransition.application.representations.*;
import gov.va.vamf.service.shifttransition.application.resources.Routes;

import javax.xml.bind.annotation.*;
import java.util.*;

/**
 * A single task summary.  Could be a completed task.
 */
@XmlRootElement(name = "task_summary", namespace = Namespace.ns)
public class PatientTaskSummary {
    /**
     * Patient id from they same facility as the nurse.
     */
    @XmlElement()
    public String patientId;

    /**
     * Unique id for the task.
     */
    @XmlElement()
    public String taskId;

    /**
     * Name of task.
     */
    @XmlElement()
    public String taskName;

    /**
     * Current task status.  No tasks with a status of NA are return.  It is possible that the status is either Completed
     * or Dismissed.
     */
    @XmlElement()
    public String status;

    /**
     * For current tasks this the next due of the task.  For completed or dismissed tasks, this is the date the task
     * was completed or dismissed. Date is a UTC timestamp.  Clients must format in the current timezone.
     */
    @XmlElement()
    public Date nextDueDate;

    /**
     * Returns related resources.
     * Titles ares: get-patient-task, complete-patient-task.
     */
    @XmlElement(name = "link")
    public List<Link> links = new ArrayList<Link>();

    public void generateLinks(Routes routes) {
        links.add(new Link("get-patient-task", routes.getPatientTask(taskId)));
        links.add(new Link("complete-patient-task", routes.getSaveCompletedTask(taskId)));
    }
}
