package gov.va.vamf.service.shifttransition.tasks.representations;

import com.google.common.collect.Lists;
import gov.va.vamf.service.shifttransition.application.representations.*;
import gov.va.vamf.service.shifttransition.application.resources.Routes;

import javax.xml.bind.annotation.*;
import java.util.*;

/**
 * Container for a list of PatientTaskSummary for a single patient.  Used to provide additional links related to all
 * patient tasks.
 */
@XmlRootElement(name = "task_summaries", namespace = Namespace.ns)
public class PatientTaskSummaries {
    @XmlElement()
    public List<PatientTaskSummary> tasks = Lists.newArrayList();

    /**
     * Returns related resources.
     * Titles ares: get-patient-tasks, add-new-task, get-completed-tasks.
     */
    @XmlElement(name = "link")
    public List<Link> links = new ArrayList<Link>();

    public void generateLinks(Routes routes) {
        Link selfLink = new Link("get-patient-task-summaries", routes.getPatientTaskSummaries());
        selfLink.rel = Link.self;

        links.add(selfLink);
        links.add(new Link("add-new-task", routes.getAddNewPatientTask()));
        links.add(new Link("get-completed-tasks", routes.getCompletedTasks()));

        for (PatientTaskSummary taskSummary : tasks) {
            taskSummary.generateLinks(routes);
        }
    }
}
