package gov.va.vamf.service.shifttransition.tasks.representations;

import gov.va.vamf.service.shifttransition.application.representations.Namespace;
import gov.va.vamf.service.shifttransition.infrastructure.exception.WebApp400BadRequestException;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.google.common.base.Strings;

/**
 * Represents the possible set of data that can be saved for a new task.
 *
 * @see UpdatedScheduledTask
 */
@XmlRootElement(name = "new_task", namespace = Namespace.ns)
public class NewScheduledTask extends UpdatedScheduledTask {
    /**
     * Required name of task.
     */
    @XmlElement(required = true)
    public String name;

    /**
     * Required type of task.
     */
    @XmlElement(required = true)
    public String type;

    /**
     * Optional url to get data used to display and complete the task.
     */
    @XmlElement()
    public String externalTaskUrl;

    public void validateInput() {
        if (Strings.isNullOrEmpty(name))
        	throw new WebApp400BadRequestException("Unable to save task. Task name was not provided.");

        if (Strings.isNullOrEmpty(type) || !type.equalsIgnoreCase("custom") && Strings.isNullOrEmpty(externalTaskUrl))
        	throw new WebApp400BadRequestException("Unable to save task. Task type not set or external task url missing.");

        super.validateInput();
    }

}
