package gov.va.vamf.service.shifttransition.tasks.domain.time;

import java.util.Date;

/**
 * Value object that represents a date range.  Both a valid beginning and ending date is required.
 */
public class Range {
    private final DueDate startDate;
    private final DueDate endDate;

    public Range(Date startDate, Date endDate) {
        this.startDate = new DueDate(startDate);
        this.endDate = new DueDate(endDate);
    }

    public boolean isInRange(DueDate date) {
        return date != null && (date.equals(startDate) || date.equals(endDate) || date.between(startDate, endDate));
    }
}
