package gov.va.vamf.service.shifttransition.tasks.domain.time;

import gov.va.vamf.service.shifttransition.infrastructure.exception.WebApp400BadRequestException;

import com.google.common.base.Strings;


/**
 * The following codes are valid: Weekly, EveryOther, EveryThird, EveryFourth
 */
public enum CustomTaskWeek {
	Weekly, EveryOther, EveryThird, EveryFourth;
	
	public static boolean isValid(String week) {
    	if (Strings.isNullOrEmpty(week))
    		return false;
    	
        try {
        }
        catch (Exception e) {
        	return false;
        }
        return true;
    }
    
    public static CustomTaskWeek fromValue(String week) {
    	if (Strings.isNullOrEmpty(week))
			throw new WebApp400BadRequestException("Week cannot be null or empty");
		
		for (CustomTaskWeek d : CustomTaskWeek.values()) {
			if (d.name().equals(week))
				return d;
		}
		throw new WebApp400BadRequestException("An unknown Week was passed into fromValue");
	}
}
