package gov.va.vamf.service.shifttransition.tasks.domain.time;

import gov.va.vamf.service.shifttransition.infrastructure.exception.WebApp400BadRequestException;

import com.google.common.base.Strings;


/**
 * Days of the week - The following 3 character codes are valid: All, Sun, Mon, Tue, Wed, Thu, Fri, Sat
 */
public enum CustomTaskDays {
	All, Sun, Mon, Tue, Wed, Thu, Fri, Sat;
	
	public static boolean isValid(String days) {
    	if (Strings.isNullOrEmpty(days))
    		return false;
    	
        try {
        }
        catch (Exception e) {
        	return false;
        }
        return true;
    }
    
    public static CustomTaskDays fromValue(String days) {
    	if (Strings.isNullOrEmpty(days))
			throw new WebApp400BadRequestException("Days cannot be null or empty");
		
		for (CustomTaskDays d : CustomTaskDays.values()) {
			if (d.name().equals(days))
				return d;
		}
		throw new WebApp400BadRequestException("An unknown Days was passed into fromValue");
	}
}
