package gov.va.vamf.service.shifttransition.tasks.domain.rules;

import gov.va.vamf.service.shifttransition.tasks.domain.Schedule;
import gov.va.vamf.service.shifttransition.tasks.domain.time.DueDate;

import java.util.Date;

/**
 * This rule is used to set the next due date for non reoccurring tasks.  The next due is set to null if the task
 * was already scheduled/ completed.
 */
public class NoneDueDateRule implements  NextDueDateRule {
    private final DueDate startDate;
    private final int numTimeScheduled;

    public NoneDueDateRule(Schedule schedule) {
        startDate = schedule.startDate();
        numTimeScheduled = schedule.numTimesScheduled();
    }

    @Override
    public Date calculateNextDueDate() {
        if (numTimeScheduled == 0)
            return startDate.get();
        else
            return null;
    }
}
