package gov.va.vamf.service.shifttransition.tasks.domain.rules;

import gov.va.vamf.service.shifttransition.tasks.domain.*;

public class NextDueDateFactory {

    public NextDueDateRule get(Schedule schedule) {
        if (schedule.scheduleType() == ScheduleType.Frequency)
            return new FrequencyDateRule(schedule);
        else if (schedule.scheduleType() == ScheduleType.Custom)
            return new CustomRule(schedule);
        else if (schedule.scheduleType() == ScheduleType.Pattern)
            return new CustomRule(schedule);
        else
            return new NoneDueDateRule(schedule);
    }
}
