package gov.va.vamf.service.shifttransition.tasks.domain.rules;

import gov.va.vamf.service.shifttransition.infrastructure.exception.WebApp400BadRequestException;
import gov.va.vamf.service.shifttransition.tasks.domain.Schedule;
import gov.va.vamf.service.shifttransition.tasks.domain.rules.parsers.FrequencyParser;
import gov.va.vamf.service.shifttransition.tasks.domain.time.DueDate;

import java.util.Date;

/**
 * This rule is used to set the next due date for interval reoccurring tasks.  The next due is set to null if
 * the number of intervals have been completed for a task.
 */
public class FrequencyDateRule implements NextDueDateRule {
    private final DueDate startDate;
    private final DueDate lastDueDate;
    private final int numTimesScheduled;

    private final FrequencyParser parser = new FrequencyParser();

    public FrequencyDateRule(Schedule schedule) {
        lastDueDate = schedule.nextDueDate();
        startDate = schedule.startDate();
        numTimesScheduled = schedule.numTimesScheduled();

        parser.parse(schedule.scheduleFrequency(), numTimesScheduled == 0);

        if (parser.intervalCount() == 0 && schedule.endDate() == null)
        	throw new WebApp400BadRequestException("Unable to save task because unable " +
                    "to calculate next due date for task.  Either an interval greater than zero or an end date is required.");
    }

    @Override
    public Date calculateNextDueDate() {
        if (parser.intervalCount() > 0 && numTimesScheduled > parser.intervalCount())
            return null;

        if (lastDueDate == null || startDate.after(lastDueDate))
            return startDate.get();

        DueDate dueDate = new DueDate(lastDueDate.get());
        parser.addFrequency(dueDate);

        return dueDate.get();
    }
}
