package gov.va.vamf.service.shifttransition.tasks.domain.rules;

import gov.va.vamf.service.shifttransition.tasks.domain.Schedule;
import gov.va.vamf.service.shifttransition.tasks.domain.time.*;
import gov.va.vamf.service.shifttransition.tasks.domain.rules.parsers.CustomParser;

import java.util.*;

/**
 * This rule is used to set the next due date for daily reoccurring tasks.
 */
public class CustomRule implements NextDueDateRule {
    private DueDate lastDueDate;
    private DueDate startDate;
    private final CustomParser parser = new CustomParser();

    public CustomRule(Schedule schedule) {
        //let's verify the timezone once, the first time the rule is executed (aka lastDueDate is null).
        //not likely that the timezone will change.
        boolean firstTime = schedule.numTimesScheduled() == 0;
		String scheduleFrequency = schedule.scheduleFrequency();
		startDate = schedule.startDate();
		DueDate nextDueDate = schedule.nextDueDate();
		
		parser.parse(scheduleFrequency, firstTime);
        setLastDueDate(startDate, nextDueDate);
    }

    private void setLastDueDate(DueDate startDate, DueDate lastDueDate) {
    	if (lastDueDate == null || startDate.after(lastDueDate))
    		this.lastDueDate = startDate;
    	else
    		this.lastDueDate = lastDueDate;
    }

    @Override
    public Date calculateNextDueDate() {
        Time lastDueTime = parser.createTimeInTimezone(lastDueDate);  //previously completed task time
        Time nextTime = parser.getTimeAfter(lastDueTime);             //next due time

        return buildNextDueDateTime(nextTime);
    }

    private Date buildNextDueDateTime(Time nextTime) {
        Time buildWithTime = nextTime;
        DueDate dueDate = parser.createDueDateInTimezone(lastDueDate);  //previously completed task date/time

        if (buildWithTime.isNull()) {
            //next day
            buildWithTime = parser.getFirstTime(); //reset time to 1st time of next day
            
            CustomTaskDays[] days = parser.getDays();
            CustomTaskWeek week = parser.getWeek();
            dueDate.addWeekAndDay(startDate, week, days);
        }

        buildWithTime.setTimeOn(dueDate);       //set next due time

        return dueDate.get();
    }
}
