package gov.va.vamf.service.shifttransition.tasks.domain;

/**
 * Available reoccurring schedule types.
 */
public enum ScheduleType {
    None, Pattern, Frequency, Custom;

    //Null translates to NONE
    public static boolean isValid(String scheduleType) {
        return scheduleType == null || scheduleType.equalsIgnoreCase(Custom.name()) ||
                scheduleType.equalsIgnoreCase(Frequency.name()) ||
                scheduleType.equalsIgnoreCase(Pattern.name());
    }

    public static ScheduleType convertFromString(String scheduleType) {
        if (scheduleType == null)
            return None;
        else if (scheduleType.equalsIgnoreCase(Custom.name()))
            return Custom;
        else if (scheduleType.equalsIgnoreCase(Frequency.name()))
            return Frequency;
        else if (scheduleType.equalsIgnoreCase(Pattern.name()))
            return Pattern;
        else
            return None;
    }
}
