package gov.va.vamf.service.shifttransition.marshal;


import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;


/**
 * Removes Cross Site Scripting (XSS) from the domain objects.<br/>
 * <b/>Example:</b> 
 * <font color="blue">"test&amp;&lt;script&gt;alert(1)&lt;/script&gt;"</font>
 * -->
 * <font color="blue">"test&amp;"</font><br/>
 * 
 * <b/>Example:</b>
 * <font color="blue">"ACROMEGALY  &lt;C&P ACROMEGALY&gt;"</font>
 * -->
 * <font color="blue">"ACROMEGALY"</font>
 * (NOTE: It removed everything between the less than and greater than symbols)<br/><br/>
 * 
 * Because JSoup and ESAPI remove scripting in different ways you have been provided with both so you can choose
 * which is correct for your needs.<br/>
 */
public class JSoupProtection extends XmlAdapter<String, String>  {

	@Override
	public String marshal(String output) throws Exception {
		String encoded = null;
		
		if (output != null){
			Document.OutputSettings outputSettings = new Document.OutputSettings().prettyPrint(false);
			encoded = Jsoup.clean(output, "", Whitelist.basic(), outputSettings);
		}
		
		if (encoded != null) {
			encoded = unescapeValidCharacters(encoded);
		}
		return encoded;
	}

	@Override
	public String unmarshal(String s) throws Exception {
		return s;
	}
	
	/**
	 * Unescaping some white list chars using String replace.
	 * 
	 * @param encoded
	 * @return
	 */
	private String unescapeValidCharacters(String encoded) {
		String updatedStr = encoded.replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">");
		return updatedStr;
	}
}
