package gov.va.vamf.service.shifttransition.infrastructure.security;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import com.google.common.base.*;
import org.slf4j.*;

/**
 * Wrapper around mphUser.
 */
public class UserServices {
    private static Logger logger = LoggerFactory.getLogger(UserServices.class);

    private MhpUser user = MhpUserFactory.createFromSecurityContext();

    public String getAssigningAuthority() {
        return user.getUserIdentifier().getAssigningAuthority();
    }

    public String getUniqueId() {
        return user.getUserIdentifier().getUniqueId();
    }

    public String getUserName() {
        if (user == null) {
            logger.warn("User not found from security context.");
            return "Unknown User";
        }

        Joiner joiner = Joiner.on(", ").skipNulls();
        String fullName = joiner.join(user.getLastName(), user.getFirstName());
        joiner = Joiner.on(" ").skipNulls();
        fullName = joiner.join(fullName, user.getMiddleInitials());

        if (Strings.isNullOrEmpty(fullName)) {
            logger.warn("User name not found for current user with id {}.", user.getId());
            return "Unknown User";
        } else
            return fullName;
    }
}
