package gov.va.vamf.service.shifttransition.infrastructure.exception;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;


/**
 * Throws a 500 error (Internal Server Error) with JSON returned containing &quot;message, uuid, and detailedDescription&quot;.  The UI will
 * display &quot;message&quot; to the end user.  The &quot;uuid and detailedDescription&quot; are written to the log.<br/>
 * Use when an internal error occurs.  Example: you are unable to connect to mongo.
 */
public class WebApp500InternalServerErrorException extends AbstractWebAppException {
	private static final long serialVersionUID = 589906516390983161L;
	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(WebApp500InternalServerErrorException.class);
	public static Status RESPONSE_STATUS = Response.Status.INTERNAL_SERVER_ERROR;
	public static String DEFAULT_MESSAGE = "Server Error";

	public WebApp500InternalServerErrorException(String detailedDescription) {
		super(RESPONSE_STATUS, DEFAULT_MESSAGE, detailedDescription);
	}
	
	public WebApp500InternalServerErrorException(String message, String detailedDescription) {
		super(RESPONSE_STATUS, message, detailedDescription);
	}

	@Override
	protected void logException() {
		String str = this.toString();
		log.error(str);
	}
}
