package gov.va.vamf.service.shifttransition.infrastructure.exception;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

/**
 * Throws a 404 error (Not Found) with JSON returned containing &quot;message, uuid, and detailedDescription&quot;.  The UI will
 * display &quot;message&quot; to the end user.  The &quot;uuid and detailedDescription&quot; are written to the log.<br/>
 * Use when something is not able to be found.  Example: Mongo is unable to find a record in the database.
 */
public class WebApp404NotFoundException extends AbstractWebAppException {
	private static final long serialVersionUID = 5032555741224171857L;
	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(WebApp404NotFoundException.class);
	public static Status RESPONSE_STATUS = Response.Status.NOT_FOUND;
	public static String DEFAULT_MESSAGE = "The requested resource is not available.";

	public WebApp404NotFoundException(String detailedDescription) {
		super(RESPONSE_STATUS, DEFAULT_MESSAGE, detailedDescription);
	}
	
	public WebApp404NotFoundException(String message, String detailedDescription) {
		super(RESPONSE_STATUS, message, detailedDescription);
	}

	@Override
	protected void logException() {
		String str = this.toString();
		log.info(str);
	}
}
