package gov.va.vamf.service.shifttransition.infrastructure.exception;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

/**
 * Throws a 400 error (Bad Request) with JSON returned containing &quot;message, uuid, and detailedDescription&quot;.  The UI will
 * display &quot;message&quot; to the end user.  The &quot;uuid and detailedDescription&quot; are written to the log.<br/>
 * Use when there is something about a record which is invalid, for example when a field must be either "Yes" or "No"
 * only and they send the word "Checked" for that field.
 */
public class WebApp400BadRequestException extends AbstractWebAppException {
	private static final long serialVersionUID = -468994248271636074L;
	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(WebApp400BadRequestException.class);
	public static Status RESPONSE_STATUS = Response.Status.BAD_REQUEST;
	public static String DEFAULT_MESSAGE = "Bad Request";

	public WebApp400BadRequestException(String detailedDescription) {
		super(RESPONSE_STATUS, DEFAULT_MESSAGE, detailedDescription);
	}
	
	public WebApp400BadRequestException(String message, String detailedDescription) {
		super(RESPONSE_STATUS, message, detailedDescription);
	}

	@Override
	protected void logException() {
		String str = this.toString();
		log.info(str);
	}
}
