package gov.va.vamf.service.shifttransition.infrastructure.exception;

import java.util.UUID;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

/**
 * Throws an error with JSON returned containing &quot;message, uuid, detailedDescription, and status&quot;.  The UI can
 * display &quot;message&quot; to the end user.  The &quot;uuid, status, and detailedDescription&quot; should be written
 * to the log by those that extend this class.
 */
public abstract class AbstractWebAppException extends WebApplicationException {
	private static final long serialVersionUID = 1L; //TODO: Change this to something unique in your app.
	
	private String message = "";
	private String detailedDescription = "";
	private String uuid = "";
	private int status = -1;

//----------------------------------------------------------------------------------------------------------------------
//---------------------------------Constructors-------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------

	public AbstractWebAppException(Status RESPONSE_STATUS, String message, String detailedDescription) {
		this(RESPONSE_STATUS.getStatusCode(), message, detailedDescription);
	}
	
	public AbstractWebAppException(int RESPONSE_STATUS, String message, String detailedDescription) {
		this(UUID.randomUUID().toString(), RESPONSE_STATUS, message, detailedDescription);
	}
	
	private AbstractWebAppException(String uuid, int RESPONSE_STATUS, String message, String detailedDescription) {
		super(Response.status(RESPONSE_STATUS)
				.entity(constructJSON(uuid, message, detailedDescription, RESPONSE_STATUS))
				.type(MediaType.APPLICATION_JSON)
				.build());
		
		this.message = message;
		this.detailedDescription = detailedDescription;
		this.status = RESPONSE_STATUS;
		this.uuid = uuid;
		
		logException();
	}
	
//----------------------------------------------------------------------------------------------------------------------
//---------------------------------Abstract Methods---------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------
	
	protected abstract void logException();

//----------------------------------------------------------------------------------------------------------------------
//---------------------------------Construct JSON from Members----------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------

	private static String constructJSON(String uuid, String message, String detailedDescription, int status) {
		String retvalue = "{\"uuid\":\"" + uuid + "\", " +
				"\"message\":\"" + message + "\", " +
				"\"detailedDescription\":\"" + detailedDescription + "\", " +
				"\"status\":\"" + status + "\"}";
		return retvalue;
	}
	
//----------------------------------------------------------------------------------------------------------------------
//---------------------------------Getters------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------

	@Override
	public String getMessage() {
		return message;
	}
	
	public String getDetailedDescription() {
		return detailedDescription;
	}

	public String getUuid() {
		return uuid;
	}

	public int getStatus() {
		return status;
	}

//----------------------------------------------------------------------------------------------------------------------
//---------------------------------toString-----------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------

	@Override
	public String toString() {
		String retvalue = constructJSON(this.uuid, this.message, this.detailedDescription, this.status);
		return retvalue;
	}
}
