package gov.va.vamf.service.shifttransition.completedtasks;

import gov.va.vamf.service.shifttransition.application.representations.Namespace;
import gov.va.vamf.service.shifttransition.infrastructure.exception.WebApp400BadRequestException;
import gov.va.vamf.service.shifttransition.tasks.domain.TaskStatus;

import java.util.Date;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.google.common.base.Strings;

/**
 * Represents data that a client can pass to the save completed task resource to save a new completed task.
 */
@XmlRootElement(name = "new_completed_task", namespace = Namespace.ns)
public class NewCompletedTask {
    @XmlElement(required = true)
    public String taskName;

    @XmlElement(required = true)
    public String status;

    @XmlElement()
    public String comment;
    
    @XmlElement()
    public Date dateCompleted;

    public void validateInput() {
        if (Strings.isNullOrEmpty(taskName) ||Strings.isNullOrEmpty(status) || !TaskStatus.isValidCompleteStatus(status))
            throw new WebApp400BadRequestException("Completed task was not saved.  " +
                    "One or more completed task required fields is missing.  Required fields are task name " +
                    "and status.");
    }
}
