package gov.va.vamf.service.shifttransition.completedtasks;

import gov.va.vamf.service.shifttransition.application.representations.Namespace;
import org.jongo.marshall.jackson.oid.*;

import javax.xml.bind.annotation.*;
import java.util.Date;

/**
 * Completed task information.
 */
@XmlRootElement(name = "completed_task", namespace = Namespace.ns)
public class CompletedTask {
    @Id
    @ObjectId
    private String _id;
    /**
     * Patient id that with site id uniquely identifies a patient.
     */
    @XmlElement()
    public String patientId;

    /**
     * Facility id that along with patient id uniquely identifies a patient.
     */
    @XmlElement()
    public String siteId;

    /**
     * Schedule task id.
     */
    @XmlElement()
    public String taskId;

    /**
     * Name of task.
     */
    @XmlElement()
    public String taskName;

    /**
     * Name of nurse that completed the task.
     */
    @XmlElement()
    public String completedBy;

    /**
     * UTC timestamp when the task was completed.
     */
    @XmlElement()
    public Date dateCompleted;

    /**
     * Task status.  Valid values are Completed or Dismissed.
     */
    @XmlElement()
    public String status;

    /**
     * Comment added by nurse when the task was completed.  This is not the same comment as found in ScheduleTask.
     */
    @XmlElement()
    public String comment;
}
