package gov.va.vamf.service.shifttransition.application.security;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

import com.agilex.healthcare.mobilehealthplatform.oauth.Oauth2AccessTokenReader;

public class Oauth2AccessTokenVerificationFilter implements Filter {
	
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(Oauth2AccessTokenVerificationFilter.class);	
	
	/**
	 * Implementation is overridden to clear the context if the token is not present in the request Authorization header or as query parameter.
	 */
	public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
		final HttpServletRequest request = (HttpServletRequest) req;
		
		Oauth2AccessTokenReader reader = new Oauth2AccessTokenReader();
		
		String tokenValue = reader.readTokenFromHttpRequest(request);
		
		if (tokenValue == null) {
			logger.info("Reading token from request parameter");
			tokenValue = request.getParameter(OAuth2AccessToken.ACCESS_TOKEN);
		}

		if (tokenValue == null) {
			logger.info("Clear the security context as token is required for the resource endpoints");
			SecurityContextHolder.clearContext();
		}
		
		chain.doFilter(request, res);
	}
	

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
	}

	@Override
	public void destroy() {
	}
}
