package gov.va.vamf.service.shifttransition.application.resources;

import gov.va.vamf.service.shifttransition.completedtasks.CompletedTasksResource;
import gov.va.vamf.service.shifttransition.tasks.PatientTasksResource;
import gov.va.vamf.service.shifttransition.userpreferences.UserPreferencesResource;
import gov.va.vamf.service.shifttransition.watchlist.PatientListResource;

import javax.ws.rs.core.UriInfo;

/**
 * Creates routes based on available resources that can be used to generate links in resources.
 *
 * IMPORTANT: There is a dependency on resource method names.
 *
 * @see gov.va.vamf.service.shifttransition.tasks.PatientTasksResource
 * @see gov.va.vamf.service.shifttransition.watchlist.PatientListResource
 * @see gov.va.vamf.service.shifttransition.application.representations.Link
 */
public class Routes {
    private final UriInfo info;
    private final String siteId;
    private final String id;

    public Routes(UriInfo info, String siteId, String id) {
        this.info = info;
        this.siteId = siteId;
        this.id = id;
    }

    //PatientListResource routes

    public String getMyList() {
        return info.getBaseUriBuilder().clone().path(PatientListResource.class).build(siteId, id).toString();
    }
    
    public String getMyPreferences() {
        return info.getBaseUriBuilder().clone().path(UserPreferencesResource.class).build(siteId, id).toString();
    }

    public String getAddPatientToMyList() {
        return getMyList();
    }

    public String getRemovePatientFromMyList(String patientId) {
        return buildUrl(PatientListResource.class, "delete", siteId, id, patientId);
    }

    public String getMyPatientsTaskSummaries() {
        return buildUrl(PatientListResource.class, "getPatientsTasks", siteId, id);
    }

    public String getMyPatientsTasksStatus() {
        return buildUrl(PatientListResource.class, "getPatientsTaskStatus", siteId, id);
    }


    //PatientTasksResource routes

    public String getPatientTaskSummaries(String patientId) {
        return info.getBaseUriBuilder().clone().path(PatientTasksResource.class).build(siteId, patientId).toString();
    }

    public String getPatientTaskSummaries() {
        return getPatientTaskSummaries(id);
    }

    public String getAddNewPatientTask() {
        return info.getBaseUriBuilder().clone().path(PatientTasksResource.class).build(siteId, id).toString();
    }

    public String getPatientTask(String taskId) {
        return buildUrl(PatientTasksResource.class, "getTask", siteId, id, taskId);
    }

    public String getUpdatePatientTask(String taskId) {
        return buildUrl(PatientTasksResource.class, "updateTask", siteId, id, taskId);
    }

    //CompletedTasksResource routes

    public String getCompletedTasks() {
        return info.getBaseUriBuilder().clone().path(CompletedTasksResource.class).build(siteId, id).toString();
    }

    public String getSaveCompletedTask(String taskId) {
        return buildUrl(CompletedTasksResource.class, "saveCompletedTask", siteId, id, taskId);
    }

    private String buildUrl(Class<?> resourceClass, String methodName, String... urlParameters) {
        return info.getBaseUriBuilder().clone().path(resourceClass)
                .path(resourceClass, methodName).build((Object[])urlParameters).toString();
    }

	public String getPatientCompletedTasks(String patientId) {
        return info.getBaseUriBuilder().clone().path(CompletedTasksResource.class).build(siteId, patientId).toString();
	}
}
