package gov.va.vamf.service.shifttransition.application.resources;

import gov.va.vamf.service.shifttransition.application.representations.Link;
import gov.va.vamf.service.shifttransition.infrastructure.exception.WebApp404NotFoundException;
import gov.va.vamf.service.shifttransition.infrastructure.security.UserServices;

import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;

/**
 * This rest service returns a resource-directory that is specific to the provider.
 */
@Path("/nsc-service/resource-directory")
@Component
@Scope("request")
public class ResourceDirectoryResource {
    /**
     * Returns the Resource Directory for Nursing Shift Companion Resources
     *
     * @return List of links to top level resources.  All other resources are reached by links provided with return
     *         representations from other resources.
     */
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public List<Link> getResourceDirectory(@Context UriInfo u, @Context HttpHeaders headers) {
        Routes routes = getRoutes(u);
        return Lists.newArrayList(new Link("my-list", routes.getMyList()),
        		new Link("my-preferences", routes.getMyPreferences()));
    }

    private Routes getRoutes(UriInfo info){
        try {
            UserServices userServices = new UserServices();
            return new Routes(info, userServices.getAssigningAuthority(), userServices.getUniqueId());
        } catch (Exception e) {
            throw new WebApp404NotFoundException("Unable to obtain Routes");
        }
    }
}
